package com.bycom.versapro.Utils;


import static com.bycom.versapro.Serializables.Constant.appConfig;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.util.Log;
import android.widget.RelativeLayout;

import androidx.annotation.NonNull;

import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.admanager.AdManagerAdView;
import com.google.android.gms.ads.admanager.AdManagerInterstitialAd;
import com.google.android.gms.ads.admanager.AdManagerInterstitialAdLoadCallback;
import com.google.android.gms.ads.appopen.AppOpenAd;

public class AdMobHelper {

    public static final long MILLISECONDS_BETWEEN_ADS = appConfig.app_settings.ad_frequency*1000;

    private final InterstitialAdManager interstitialAdManager;
    private final BannerAdManager bannerAdManager;
    private final AppOpenAdManager appOpenAdManager;

    private static long lastAdShownTime = 0;







    public AdMobHelper(Context context) {






        new Thread(() -> MobileAds.initialize(context, initializationStatus -> {})).start();

        interstitialAdManager = new InterstitialAdManager();
        interstitialAdManager.loadAd(context);

        bannerAdManager = new BannerAdManager();

        appOpenAdManager = new AppOpenAdManager();
        appOpenAdManager.loadAd(context);





    }

    public static class InterstitialAdManager {

        private AdManagerInterstitialAd mAdManagerInterstitialAd = null;

        private void loadAd(Context context) {
            if(appConfig.app_settings.AdMobInterstitialEnabled()) {
                AdManagerAdRequest adRequest = new AdManagerAdRequest.Builder().build();
                AdManagerInterstitialAd.load(context, appConfig.app_settings.admob_interstitial_id, adRequest,
                        new AdManagerInterstitialAdLoadCallback() {
                            @Override
                            public void onAdLoaded(@NonNull AdManagerInterstitialAd interstitialAd) {
                                mAdManagerInterstitialAd = interstitialAd;
                            }

                            @Override
                            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                                mAdManagerInterstitialAd = null;
                            }
                        });
            }
        }

        public void showAd(Activity activity) {
            if (appConfig.app_settings.AdMobInterstitialEnabled()) {

                if (System.currentTimeMillis() - lastAdShownTime < MILLISECONDS_BETWEEN_ADS)
                    return;


                if (mAdManagerInterstitialAd != null) {

                    // Show the ad
                    mAdManagerInterstitialAd.show(activity);

                    // Set a callback to load a new ad after the current one is shown
                    mAdManagerInterstitialAd.setFullScreenContentCallback(new FullScreenContentCallback() {
                        @Override
                        public void onAdShowedFullScreenContent() {
                            super.onAdShowedFullScreenContent();
                            // Update the last ad shown time

                            loadAd(activity);
                        }

                        @Override
                        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
                            loadAd(activity);
                        }
                        @Override
                        public void onAdDismissedFullScreenContent() {
                            lastAdShownTime = System.currentTimeMillis();
                        }
                    });
                } else {
                    Log.d("TAG", "The interstitial ad wasn't ready yet.");
                    loadAd(activity);
                }
            }
        }

    }



    public static class BannerAdManager {


        public void getInlineAdView(Activity activity,BannerAdCallback callback) {
            if (appConfig.app_settings.AdMobBannerEnabled()) {
                int displayWidthInDp = (int) (activity.getResources().getDisplayMetrics().widthPixels / activity.getResources().getDisplayMetrics().density);
                AdSize adSize = AdSize.getCurrentOrientationInlineAdaptiveBannerAdSize(activity, displayWidthInDp-20);

                AdManagerAdView bannerView = new AdManagerAdView(activity);
                bannerView.setAdUnitId(appConfig.app_settings.admob_banner_id);
                bannerView.setAdSizes(adSize);


                bannerView.setAdListener(new AdListener() {
                    @Override
                    public void onAdLoaded() {
                        super.onAdLoaded();
                        Log.d("AdListener", "Ad loaded successfully.");
                        bannerView.setAdListener(new AdListener() {});
                        callback.onSuccess(bannerView);
                    }

                    @Override
                    public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                        super.onAdFailedToLoad(loadAdError);
                        bannerView.setAdListener(new AdListener() {});
                        callback.onFailed();
                    }

                });


                AdManagerAdRequest adRequest = new AdManagerAdRequest.Builder().build();
                bannerView.loadAd(adRequest);


            }
        }


        public void getAnchoredAdView(Activity activity, BannerAdCallback callback) {
            if (appConfig.app_settings.AdMobBannerEnabled()) {
                int displayWidthInDp = (int) (activity.getResources().getDisplayMetrics().widthPixels / activity.getResources().getDisplayMetrics().density);
                AdSize adSize = AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize(activity, displayWidthInDp-20);

                AdManagerAdView bannerView = new AdManagerAdView(activity);
                bannerView.setAdUnitId(appConfig.app_settings.admob_banner_id);
                bannerView.setAdSizes(adSize);



                bannerView.setAdListener(new AdListener() {
                    @Override
                    public void onAdLoaded() {
                        super.onAdLoaded();
                        Log.d("AdListener", "Ad loaded successfully.");
                        bannerView.setAdListener(new AdListener() {});
                        callback.onSuccess(bannerView);
                    }

                    @Override
                    public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                        super.onAdFailedToLoad(loadAdError);
                        bannerView.setAdListener(new AdListener() {});
                        callback.onFailed();
                    }


                });


                AdManagerAdRequest adRequest = new AdManagerAdRequest.Builder().build();
                bannerView.loadAd(adRequest);


            }
        }



    }



    public static class AppOpenAdManager {

        private static final String TAG = "AppOpenAdManager";

        private AppOpenAd appOpenAd = null;
        private boolean isLoadingAd = false;
        private boolean isShowingAd = false;





        // Show the app open ad if it's available
        public void showAdIfAvailable(Activity activity) {
            if(appConfig.app_settings.AdMobOpenOpenEnabled()) {
                if (isShowingAd) {
                    Log.d(TAG, "The app open ad is already showing.");
                    return;
                }

                if (System.currentTimeMillis() - lastAdShownTime < MILLISECONDS_BETWEEN_ADS)
                    return;


                if (appOpenAd != null) {
                    appOpenAd.setFullScreenContentCallback(new FullScreenContentCallback() {
                        @Override
                        public void onAdDismissedFullScreenContent() {
                            Log.d(TAG, "Ad dismissed.");
                            appOpenAd = null;
                            isShowingAd = false;
                            loadAd(activity);
                            lastAdShownTime = System.currentTimeMillis();
                        }

                        @Override
                        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
                            Log.d(TAG, "Failed to show ad: " + adError.getMessage());
                            appOpenAd = null;
                            isShowingAd = false;
                        }

                        @Override
                        public void onAdShowedFullScreenContent() {
                            Log.d(TAG, "Ad showed.");
                            isShowingAd = true;
                        }
                    });

                    new Handler().postDelayed(() -> appOpenAd.show(activity), 100);


                } else {
                    Log.d(TAG, "App open ad is not ready yet.");
                    loadAd(activity);
                }
            }
        }

        // Load an app open ad
        public void loadAd(Context context) {
            if (appConfig.app_settings.AdMobOpenOpenEnabled()) {
                if (isLoadingAd || appOpenAd != null) {
                    return;
                }

                Log.e("faslfjasklfj", "LoadAdCalled");

                isLoadingAd = true;
                AdRequest adRequest = new AdRequest.Builder().build();
                AppOpenAd.load(context, appConfig.app_settings.admob_app_open_id, adRequest, new AppOpenAd.AppOpenAdLoadCallback() {
                    @Override
                    public void onAdLoaded(@NonNull AppOpenAd ad) {
                        appOpenAd = ad;
                        isLoadingAd = false;
                        Log.d(TAG, "App open ad loaded.");
                    }

                    @Override
                    public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                        isLoadingAd = false;
                        Log.d(TAG, "Failed to load ad: " + loadAdError.getMessage());
                    }
                });
            }
        }
    }

    public InterstitialAdManager getInterstitialAdManager(){
        return interstitialAdManager;
    }

    public BannerAdManager getBannerAdManager(){
        return bannerAdManager;
    }

    public AppOpenAdManager getAppOpenAdManager(){
        return appOpenAdManager;
    }



    public interface BannerAdCallback{

        void onSuccess(AdManagerAdView adManagerAdView);


        void onFailed();

    }

}

